/*
 * Decompiled with CFR 0.152.
 */
package jade.util.leap;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class OutputViewer
extends MIDlet
implements CommandListener {
    private static final String OUTPUT = "OUTPUT";
    private final Command clearCommand = new Command("Clear", 1, 1);
    private final Command tailCommand = new Command("Tail", 1, 1);
    private Display display = Display.getDisplay((MIDlet)this);
    private Form myForm;

    public void startApp() {
        this.refresh();
        this.readAll();
    }

    private void refresh() {
        this.myForm = new Form(OUTPUT);
        this.myForm.addCommand(this.tailCommand);
        this.myForm.addCommand(this.clearCommand);
        this.myForm.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.myForm);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    public void commandAction(Command c, Displayable d) {
        if (d == this.myForm) {
            if (c == this.clearCommand) {
                try {
                    Class.forName("jade.util.Logger");
                    this.refresh();
                }
                catch (Exception e) {
                    this.showError("Cannot clear output. " + e.getMessage());
                }
            } else if (c == this.tailCommand) {
                this.refresh();
                this.readTail();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAll() {
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)OUTPUT, (boolean)true);
            int size = rs.getNumRecords();
            int i = 0;
            while (i < size) {
                byte[] bb = rs.getRecord(i + 1);
                StringItem line = new StringItem(null, new String(bb));
                this.myForm.append((Item)line);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showError("Cannot open OUTPUT record store. " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.closeRecordStore();
                }
            }
            catch (Exception any) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTail() {
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)OUTPUT, (boolean)true);
            int size = rs.getNumRecords();
            int i = 0;
            while (i < 10) {
                if (size - i <= 0) {
                    break;
                }
                byte[] bb = rs.getRecord(size - i);
                StringItem line = new StringItem(null, new String(bb));
                this.myForm.append((Item)line);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showError("Cannot open OUTPUT record store. " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.closeRecordStore();
                }
            }
            catch (Exception any) {}
        }
    }

    private void showError(String msg) {
        Alert alert = new Alert("ERROR", msg, null, AlertType.ERROR);
        this.display.setCurrent((Displayable)alert);
    }
}

